<?php
use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Включение двухфакторной авторизации';
$this->params['breadcrumbs'][] = ['label' => '2FA', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="twofa-enable">
    <h1><?= Html::encode($this->title) ?></h1>

    <div class="row">
        <div class="col-md-8 col-md-offset-2">
            <div class="panel panel-success">
                <div class="panel-heading">
                    <h3 class="panel-title">Настройка Google Authenticator</h3>
                </div>
                <div class="panel-body">
                    <div class="alert alert-info">
                        <strong>Шаг 1:</strong> Установите приложение Google Authenticator на ваш телефон
                        <br>Доступно в App Store и Google Play
                    </div>

                    <div class="alert alert-warning">
                        <strong>Шаг 2:</strong> Отсканируйте QR-код или введите секретный ключ вручную
                    </div>

                    <div class="text-center" style="margin: 30px 0;">
                        <div id="qrcode"></div>
                    </div>
                    <div class="well text-center">
                        <strong>Секретный ключ:</strong><br>
                        <code style="font-size: 24px; letter-spacing: 2px;"><?= $secret ?></code>
                        <br>
                        <button class="btn btn-sm btn-default" onclick="copySecret()" style="margin-top: 10px;">
                            Скопировать ключ
                        </button>
                        <br>
                        <small class="text-muted">
                            Если не можете отсканировать QR-код, введите этот ключ вручную в приложении
                        </small>
                    </div>

                    <div class="alert alert-success">
                        <strong>Шаг 3:</strong> Введите 6-значный код из приложения для подтверждения
                    </div>

                    <?php if (Yii::$app->session->hasFlash('error')): ?>
                        <div class="alert alert-danger">
                            <?= Yii::$app->session->getFlash('error') ?>
                        </div>
                    <?php endif; ?>

                    <form action="<?= Url::to(['verify']) ?>" method="post">
                        <input type="hidden" name="_csrf" value="<?= Yii::$app->request->csrfToken ?>">

                        <div class="form-group">
                            <label for="code">Код из приложения</label>
                            <input type="text" class="form-control input-lg" id="code" name="code"
                                   placeholder="Введите 6-значный код" maxlength="6" pattern="[0-9]{6}"
                                   required autofocus style="font-size: 24px; text-align: center; letter-spacing: 5px;">
                        </div>

                        <?= Html::submitButton('Проверить и включить 2FA', [
                            'class' => 'btn btn-success btn-lg btn-block'
                        ]) ?>
                    </form>

                    <hr>

                    <div class="text-center">
                        <?= Html::a('Вернуться в личный кабинет', ['index'], ['class' => 'btn btn-link']) ?>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>

<script>
    var issuer = '<?= Yii::$app->params['siteName'] ?? Yii::$app->id ?? 'MySite' ?>';
    var username = '<?= $user->username ?>';
    var secret = '<?= $secret ?>';

    var otpAuthUrl = 'otpauth://totp/' + encodeURIComponent(issuer) + ':' + encodeURIComponent(username) +
        '?secret=' + secret +
        '&issuer=' + encodeURIComponent(issuer);

    new QRCode(document.getElementById("qrcode"), {
        text: otpAuthUrl,
        width: 250,
        height: 250
    });

    function copySecret() {
        navigator.clipboard.writeText(secret).then(function() {
            alert('Секретный ключ скопирован в буфер обмена');
        }, function() {
            alert('Не удалось скопировать. Скопируйте ключ вручную.');
        });
    }

    document.getElementById('code').addEventListener('input', function(e) {
        if (this.value.length === 6) {
            this.form.submit();
        }
    });
</script>

<style>
    #qrcode {
        display: inline-block;
        padding: 10px;
        background: white;
        border: 1px solid #ddd;
        border-radius: 5px;
    }
    #qrcode img {
        display: block;
        margin: 0 auto;
    }
    code {
        background: #f5f5f5;
        padding: 10px;
        border-radius: 4px;
        display: inline-block;
    }
</style>