<?php
use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Подтверждение кода';
$this->params['breadcrumbs'][] = ['label' => '2FA', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>

    <div class="twofa-verify">
        <div class="row">
            <div class="col-md-6 col-md-offset-3">
                <div class="panel panel-primary">
                    <div class="panel-heading">
                        <h3 class="panel-title">Подтверждение кода</h3>
                    </div>
                    <div class="panel-body">

                        <?php if (Yii::$app->session->hasFlash('error')): ?>
                            <div class="alert alert-danger">
                                <?= Yii::$app->session->getFlash('error') ?>
                            </div>
                        <?php endif; ?>

                        <p>Введите 6-значный код из приложения Google Authenticator:</p>

                        <form action="<?= Url::to(['verify']) ?>" method="post">
                            <input type="hidden" name="_csrf" value="<?= Yii::$app->request->csrfToken ?>">

                            <div class="form-group">
                                <input type="text" class="form-control input-lg text-center"
                                       name="code" placeholder="______" maxlength="6" pattern="[0-9]{6}"
                                       style="font-size: 30px; letter-spacing: 10px;" autofocus required>
                            </div>

                            <div class="form-group">
                                <?= Html::submitButton('Проверить', ['class' => 'btn btn-primary btn-block']) ?>
                            </div>
                        </form>

                        <hr>

                        <?= Html::a('Назад', ['enable'], ['class' => 'btn btn-link']) ?>

                    </div>
                </div>
            </div>
        </div>
    </div>

<?php
$js = <<<JS
$('input[name="code"]').on('input', function() {
    if ($(this).val().length === 6) {
        $(this).closest('form').submit();
    }
});
JS;
$this->registerJs($js);
?>